/* $Id: minarb.c,v 1.6 1999/06/17 23:40:46 donwm Exp $ */
/* Copyright (C) 1997 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Keith Bayern */

/* 
/*  minimal arb source program
/* 
/* This program sets up one source channel for arb source
/*
/* the first optional argument accepted is the logical address
/*
/* each following argument is a source channel number starting from 1
/*
/* minarb 9 1 3     would use board at LA=9 and turnon channels 1 and 3
/*
/* */



#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "hpe1432.h"

#define SOURCE_BLOCKSIZE 1024

void main(int argc, char *argv[])
{
ViSession	vi;
ViInt32		channels[10];
ViInt32		gid;
ViInt32		rdyflag;
ViInt32		rdycount;
ViInt32		srcdata[SOURCE_BLOCKSIZE];
char		st[100];
ViInt32		i;
ViInt32		x;
ViStatus	vierr;
ViInt32		srcmode;
ViInt32		srcblocksize;
ViInt32		numsources;
ViChar		initstr[100];

ViInt32		chan;

    srcblocksize=SOURCE_BLOCKSIZE;


printf("minarb [Address [channel [channel ...]]]\n");
printf("example    minarb 9 3 4    turns on LA=9 channels sources 3 and 4\n");

    /* get logical address */
    if(argc<2)
    {
        sprintf(initstr,"VXI0::%s::INSTR","8");
    }
    else
    {
        sprintf(initstr,"VXI0::%s::INSTR",argv[1]);
    }

    /* get channels */
    if(argc<3)
    {
	channels[0]=4097;
	numsources=1;
    }
    else
    {
        numsources=0;
        while(numsources<argc-2)
	{
	    channels[numsources++]=4096+atoi(argv[numsources+2]);
	}
    }

    /* show selections */
    printf("init string = %s\n",initstr);
    printf("channels: ");
    for(i=0;i<numsources;i++)
        printf("%d ",channels[i]);
    printf("\n");

    /* initialize instrument  This code ASSUMES hpe1432 at address 8 */
    vierr=hpe1432_init(initstr,0,1,&vi);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);	    
        exit(0);
    }


    vierr=hpe1432_createChannelGroup(vi,numsources,channels,&gid);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    vierr=hpe1432_setClockFreq(vi, gid, 51200.0);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    vierr = hpe1432_setActive(vi, gid, HPE1432_CHANNEL_ON);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    vierr = hpe1432_setDutyCycle(vi, gid, 1.0);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    srcmode = HPE1432_SOURCE_MODE_RANDZ;
    srcmode = HPE1432_SOURCE_MODE_BRANDZ;
    srcmode = HPE1432_SOURCE_MODE_BARB;
    srcmode = HPE1432_SOURCE_MODE_BRAND;
    srcmode = HPE1432_SOURCE_MODE_SINE;
    srcmode = HPE1432_SOURCE_MODE_RAND;
    srcmode = HPE1432_SOURCE_MODE_BSINE;
    srcmode = HPE1432_SOURCE_MODE_ARB;

    vierr = hpe1432_setSourceMode(vi, gid, srcmode);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    vierr=hpe1432_setSourceBlocksize(vi, gid, srcblocksize);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    vierr = hpe1432_setRampRate(vi, gid, 0.0);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }


    vierr = hpe1432_setRange(vi, gid, 10.0);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    vierr = hpe1432_setAmpScale(vi, gid, 1.0);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    vierr=hpe1432_setSrcBufferMode(vi, gid, HPE1432_SRC_BUFFER_PERIODIC_A);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }
  

    vierr = hpe1432_setSrcBufferSize(vi, gid, srcblocksize );
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }
  

    vierr=hpe1432_setSrcBufferInit(vi, gid, HPE1432_SRC_BUFFER_INIT_EMPTY);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }
 
 for(chan=0;chan<numsources;chan++)
 {
    /* make arb data */
    for(i=0;i<srcblocksize;i++)
    {
       srcdata[i] = i;
    }

    /* dont swapping data is not needed, it is here for testing only */
    /* swap blocks of the data */
/*
    for(i=0;i<srcblocksize/4;i++)
    {
       x = srcdata[i];
       srcdata[i] = srcdata[i + 1 * srcblocksize / 4];
       srcdata[i + 1 * srcblocksize / 4] = x;
       
       x = srcdata[i + 2 * srcblocksize / 4];
       srcdata[i + 2 * srcblocksize / 4] = srcdata[i + 3 * srcblocksize / 4];
       srcdata[i + 3 * srcblocksize / 4] = x;
    }
*/
    /* scale for transfer normalize to 2<23 then shift left 8  */
    for(i=0;i<srcblocksize;i++)
    {
       srcdata[i] = (ViInt32)((((ViReal64)srcdata[i])/srcblocksize)*(1<<22));
       srcdata[i] = srcdata[i]<<8;
    }
     

    if(  srcmode == HPE1432_SOURCE_MODE_ARB ||  srcmode == HPE1432_SOURCE_MODE_ARB)
    {
        rdycount = 0;
        do 
        {
            rdyflag = 0;
            vierr = hpe1432_checkSrcArbRdy(vi, channels[chan],
				    HPE1432_SRC_DATA_MODE_WAITA, &rdyflag);
            if(vierr)
            {
                hpe1432_error_message(vi,vierr,st);
                printf("error %d = %s\n",vierr,st);
                exit(0);
            }
      
            rdycount = rdycount + 1;
            if (rdycount > 100000) 
            {
                printf( "The arbritray source is refusing to take data\n");
                exit(0);
            }
          
        }
        while (rdyflag == 0);
      
      
        /* write arb source data */
        vierr = hpe1432_writeSrcBufferData(vi, channels[chan],  srcdata,
		      srcblocksize, HPE1432_SRC_DATA_MODE_WAITA);
        if(vierr)
        {
            hpe1432_error_message(vi,vierr,st);
            printf("error %d = %s\n",vierr,st);
            exit(0);
        }
    }  
 }
    
    vierr = hpe1432_setSineFreq(vi, gid, 1000.0);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    vierr = hpe1432_setRange(vi, gid, 10.0);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    /* start source */
    vierr=hpe1432_initMeasure(vi,gid);
    if(vierr)
    {
        hpe1432_error_message(vi,vierr,st);
        printf("error %d = %s\n",vierr,st);
        exit(0);
    }

    printf("arb data should be playing now\n");
    
}




